// Initialise the Zendesk JavaScript API client
// https://developer.zendesk.com/apps/docs/apps-v2
let appLocation = "";
let userGroups = [];
let userRole = "";
$(document).ready(function() {
    var client = ZAFClient.init();

    client.context().then(function(context) {
        appLocation = context.location; 

        if(appLocation == "user_sidebar") {
            client.invoke('show');
        } else {
            client.invoke('hide');
        }
    });

    client.get("currentUser").then(function(user) {
        userGroups = user.currentUser.groups;
        userRole = user.currentUser.role;
        client.context().then(function(context) {
            appLocation = context.location;

            client.metadata().then(function(metadata) {
                let userRestricted = isUserRoleRestricted(metadata.settings.disable_fields_for_user_roles);
                let userGroupRestricted = isUserGroupRestricted(metadata.settings.disable_fields_for_groups);
                if(userRestricted || userGroupRestricted) {
                    hideAndDisableFields(metadata);
                }
            });
        });
    });

    function isUserRoleRestricted(restrictedRoles) {
        let roles = restrictedRoles ? restrictedRoles.split(",") : [];
        let result = false;
        $.each(roles, function(idx, role) {
            if(role.trim() == userRole) {
                result = true;
            }
        });

        return result;
    };

    function isUserGroupRestricted(restrictedGroups) {
        let groups = restrictedGroups ? restrictedGroups.split(",") : [];
        let result = false;
        userGroups = $.map(userGroups, function( value, key ) {
            return value.id;
        });


        $.each(groups, function(idx, group) {
            if(userGroups.indexOf(parseInt(group.trim())) > -1) {
                result = true;
            }
        });

        return result;
    };

    function hideAndDisableFields(metadata) {
        if(appLocation == "ticket_sidebar") {
            let fieldsToDisable = metadata.settings.disable_fields_in_ticket_sidebar ? metadata.settings.disable_fields_in_ticket_sidebar.split(",") : [];
            let fieldsToHide = metadata.settings.hide_fields_in_ticket_sidebar ? metadata.settings.hide_fields_in_ticket_sidebar.split(",") : [];

            $.each(fieldsToDisable, function(idx, field) {
                hideOrDisable(field.trim(), "disable");
            });

            $.each(fieldsToHide, function(idx, field) {
                hideOrDisable(field.trim(), "hide");
            });
        }

        if(appLocation == "user_sidebar") {
            let fieldsToHide = metadata.settings.hide_fields_in_user_sidebar ? metadata.settings.hide_fields_in_user_sidebar.split(",") : [];
            let fieldsToDisable = metadata.settings.disable_fields_in_user_sidebar ? metadata.settings.disable_fields_in_user_sidebar.split(",") : [];

            $.each(fieldsToHide, function(idx, field) {
                hideOrDisable(field.trim(), "hide");
            });

            $.each(fieldsToDisable, function(idx, field) {
                userDisableField(field.trim());
            });
        }
    };

    function hideOrDisable(fieldID, type) {
        if(appLocation == "ticket_sidebar") { 
            client.invoke('ticketFields:custom_field_'+fieldID+'.'+type);
        }

        if(appLocation == "user_sidebar") { 
            client.invoke('userFields:'+fieldID+'.'+type);
        }

    };

    function userDisableField(fieldID) {
        hideOrDisable(fieldID, "hide");
        let $tr = $("<tr></tr>");

        client.get('user').then(function(data) {
            let userURL = {
                url: '/api/v2/users/'+data.user.id+'.json',
                type: 'GET',
                contentType: 'application/json'
            };
            client.request(userURL).then(function(user) {
                let userFieldValue = user.user.user_fields[fieldID];
                
                $tr.append('<td>'+fieldID+'</td><td>'+userFieldValue+'</td>');
            });
        });

        $("#customFieldTbl").append($tr);
    };

});
